﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class ClearPageFileAtShutdown : UserControl,IControl,ICorrespondenceOS
    {
        private ClearPageFileAtShutdownController clearPageFileAtShutdownController;

        public ClearPageFileAtShutdown()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,                                             
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetClearPageFileAtShutdownState(bool b)
        {
            checkBox1.Checked = b;
        }


        public int GetClearPageFileAtShutdownState()
        {
            if (checkBox1.Checked)
            {
                return 1;
            }
            return 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            clearPageFileAtShutdownController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return clearPageFileAtShutdownController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void ClearPageFileAtShutdown_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            clearPageFileAtShutdownController = new ClearPageFileAtShutdownController(this,
                                                                        (IClearPageFileAtShutdownStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new ClearPageFileAtShutdownDefaultStrategy()
                                                                                 }));
            clearPageFileAtShutdownController.Read();
        }
    }
}
